#include <algorithm>
#include <iostream>
#include <vector>
using namespace std;

void merge(vector<int>& za_sort, int left, int mid, int right)
{
    int i;
    int j;
    int k;
    int gornji_deo_broj = mid - left + 1;
    int donji_deo_broj = right - mid;

    vector<int> levi_vec(gornji_deo_broj);
    vector<int> desni_vec(donji_deo_broj);

    for (i = 0; i < donji_deo_broj; i++)
    {
        levi_vec[i] = za_sort[left + i];
    }

    for (j = 0; j < donji_deo_broj; j++)
    {
        desni_vec[j] = za_sort[mid + 1 + j];
    }


    i = 0;
    j = 0;
    k = left;
    while (i < gornji_deo_broj && j < donji_deo_broj)
    {
        if (levi_vec[i] <= desni_vec[j])
        {
            za_sort[k] = levi_vec[i];
            i++;
        }
        else
        {
            za_sort[k] = desni_vec[j];
            j++;
        }
        k++;
    }

    while (i < gornji_deo_broj)
    {
        za_sort[k] = levi_vec[i];
        i++;
        k++;
    }

    while (j < donji_deo_broj)
    {
        za_sort[k] = desni_vec[j];
        j++;
        k++;
    }
}

int mergeSort(vector<int>& to_sort, int left, int right)
{
    int cost = 0;
    if (left < right)
    {
        int mid = left + (right - left) / 2;

        auto sstart = to_sort.begin();
        if (!is_sorted(sstart + left, sstart + mid + 1))
        {
            cost += mergeSort(to_sort, left, mid);
        }
        if (!is_sorted(sstart + mid + 1, sstart + right + 1))
        {
            cost += mergeSort(to_sort, left, mid);
        }

        merge(to_sort, left, mid, right);
        cost += 1;
    }
    return cost;
}


int GetCost(vector<int> & vec)
{
    return mergeSort(vec, 0,static_cast<int>(vec.size() - 1));
}

void MutateVector(vector<int> & vec, pair<int, int> const & to_swap)
{
    swap(vec[to_swap.first - 1], vec[to_swap.second - 1]);
}

int main()
{
    int N, Q;
    cin >> N >> Q;
    vector<int> P;
    int temp;
    for (int i = 0; i < N; i++)
    {
        cin >> temp;
        P.push_back(temp);
    }

    vector<pair<int, int>> TicketPos;
    int t1, t2;
    for (int i = 0; i < Q; i++)
    {
        cin >> t1 >> t2;
        TicketPos.emplace_back(t1, t2);
    }


    vector vec1(P);
    int cost = GetCost(vec1);
    cout << cost << "\n";
    for (auto & [i, j] : TicketPos)
    {
        MutateVector(P,{i,j});
        vector vec2(P);
        int cost = GetCost(vec2);
        cout << cost << "\n";
    }
}